import { NextRequest, NextResponse } from 'next/server';
import { getDatabase, initDatabase } from '@/src/lib/database';

// PUT - עדכון פלאפון
export async function PUT(request: NextRequest, { params }: { params: Promise<{ id: string }> }) {
    try {
        await initDatabase();
        const db = await getDatabase();
        const updates = await request.json();

        const now = new Date().toISOString();

        const resolvedParams = await params;
        return new Promise<NextResponse>((resolve, reject) => {
            const sql = `UPDATE phones SET 
        phone = COALESCE(?, phone),
        domain = COALESCE(?, domain),
        website = COALESCE(?, website),
        owner = COALESCE(?, owner),
        email = COALESCE(?, email),
        package = COALESCE(?, package),
        amount = COALESCE(?, amount),
        status = COALESCE(?, status),
        priority = COALESCE(?, priority),
        startDate = COALESCE(?, startDate),
        nextPayment = COALESCE(?, nextPayment),
        notes = COALESCE(?, notes),
        updatedAt = ?
        WHERE id = ?`;

            db.run(sql, [
                updates.phone, updates.domain, updates.website, updates.owner, updates.email,
                updates.package, updates.amount, updates.status, updates.priority,
                updates.startDate, updates.nextPayment, updates.notes, now, resolvedParams.id
            ], function (err) {
                if (err) {
                    console.error('Error updating phone:', err);
                    reject(NextResponse.json({ error: err.message }, { status: 500 }));
                } else {
                    resolve(NextResponse.json({ message: 'Phone updated successfully' }));
                }
            });
        });
    } catch (error) {
        console.error('Database error:', error);
        return NextResponse.json({ error: 'Database error' }, { status: 500 });
    }
}

// DELETE - מחיקת פלאפון
export async function DELETE(request: NextRequest, { params }: { params: Promise<{ id: string }> }) {
    try {
        await initDatabase();
        const db = await getDatabase();

        const resolvedParams = await params;
        return new Promise<NextResponse>((resolve, reject) => {
            db.run('DELETE FROM phones WHERE id = ?', [resolvedParams.id], function (err) {
                if (err) {
                    console.error('Error deleting phone:', err);
                    reject(NextResponse.json({ error: err.message }, { status: 500 }));
                } else {
                    resolve(NextResponse.json({ message: 'Phone deleted successfully' }));
                }
            });
        });
    } catch (error) {
        console.error('Database error:', error);
        return NextResponse.json({ error: 'Database error' }, { status: 500 });
    }
}
